 /* 'mrTexture.h' */

 /* Nagowek typw bazowych Mirus */
#include "mrDatatypes.h"
 /* Nagwek definicji bdw Mirus */
#include "mrError.h"
 /* Nagwek obrazu RGBA biblioteki Mirus */
#include "mrRGBAImage.h"
 /* Nagwek ekranu Mirus */
#include "mrScreen.h"
/* Plik nagwka grafiki DirectX */
#include <d3d8.h> 

 /* Zaczaj ten plik tylko raz */
#pragma once

 /* Klasa tekstury Mirus */
class mrTexture
{
protected:
  /* Powierchnia Direct3D */
 LPDIRECT3DTEXTURE8 m_pkD3DTexture;
 mrRGBAImage *      m_pkRawImage;

 mrUInt32           m_iID;
 mrBool32           m_iHasAlpha;

  /* Skadniki obsugowe */
 static mrUInt32    m_iActiveTexture;
 static mrUInt32    m_iCurrentID;

public:
  /* Konstruktory / Destruktor */
 mrTexture (void);
 ~mrTexture (void);

  /* Procedury manipulujce teksturami */
 mrError32 Create (mrRGBAImage * pkRawImage);
 mrError32 Update (void);

 void SetRawImage (mrRGBAImage * pkRawImage);
 mrRGBAImage * GetRawImage (void);

  /* Procedury obsugowe tekstur */
 void SetActiveTexture (void);
 mrUInt32 GetID (void);

 static mrUInt32 GetActiveTexture (void);
};
